//////////////////////////////////////////////////////////////////////
//	File: "Debug.h"
//
//	Author: Andrew Kreyvanis
//
//	Purpose: Enables a debug window in release mode.
//////////////////////////////////////////////////////////////////////
#ifndef DEBUG_H_
#define DEBUG_H_

#define CONSOLEDEBUG

#ifdef CONSOLEDEBUG
	#include <iostream>
	#define CONSOLEMSG std::cout 
	#define WINDOWXPOS 620
	#define WINDOWYPOS 10
#else
	#define Comment(s) /##s
	#define CONSOLEMSG Comment(/)
	#define WINDOWXPOS (GetSystemMetrics(SM_CXSCREEN)/2) - (windowWidth/2)
	#define WINDOWYPOS (GetSystemMetrics(SM_CYSCREEN)/2) - (windowHeight/2)
#endif

#endif